//-------------------------------------------------
procedure CheckCommandLine;
const
  cClassA = 'TFormViewUV';
  cClassW = cClassA + '.UnicodeClass';
  cClassName: array[Boolean] of PChar = (cClassA, cClassW);
var  
  S, SS: WideString;
  Wnd: THandle;
  Data: TCopyDataStruct;
  ASingleInst: boolean;
begin
  S:= SParamStrW(1);

  //Don't check control parameters
  if Pos('/', S) = 1 then
    S:= '';

  if S <> '' then
    begin
    SS:= S;

    //Handle @Filelist parameter
    if Pos('@', SS) = 1 then
      Delete(SS, 1, 1);

    //Check filename existing
    //(do not check folders)
    if not IsDirExist(SS) then
      begin
      if not IsFileExist(SS) then
        begin
        MsgError(SFormatW(MsgViewerErrCannotFindFile, [SS]));
        Halt
        end;

      if not IsFileAccessed(SS) then
        begin
        MsgError(SFormatW(MsgViewerErrCannotOpenFile, [SS]));
        Halt
        end;
      end;
    end;

  //Handle "Single instance" option
  with TIniFile.Create(ConfigFolder + '\Viewer.ini') do
  try
    ASingleInst:= ReadBool(csOpt, ccOSingleInst, false);
  finally
    Free;
  end;

  if ASingleInst then
    begin
    Wnd:= FindWindow(cClassName[Win32Platform = VER_PLATFORM_WIN32_NT], nil);
    if Wnd <> 0 then
      begin
      FillChar(Data, SizeOf(Data), 0);
      Data.dwData:= 101; //"Open Unicode filename"
      if S <> '' then
        begin
        Data.cbData:= (Length(S) + 1) * 2;
        Data.lpData:= PWChar(S);
        end;
      SendMessage(Wnd, WM_COPYDATA, 100{hWnd}, integer(@Data));
      SetForegroundWindow(Wnd);
      Halt;
      end;
    end;
end;

//-------------------------------------------------
function TFormViewUV.ReadCommandLine: WideString;
  //
  function SGetListValue(var S: WideString): WideString;
  var
    i: integer;
  begin
    i:= Pos(',', s);
    if i = 0 then i:= MaxInt;
    Result:= Copy(s, 1, i-1);
    Delete(s, 1, i);
  end;
  //
var
  i: integer;
  S, SU: WideString;
begin
  Result:= '';

  FStartupPosDo:= false;
  FStartupPosPercent:= false;
  FStartupPos:= 0;

  for i:= 1 to SParamCount do
    begin
    S:= SParamStrW(i);
    SU:= UpperCase(S);

    //Handle control parameters
    if Pos('/', S) = 1 then
      begin
      // /Q: Start in "Quick View" mode.
      if SU = '/Q' then
        begin
        FQuickViewMode:= true;

        //Hide menu 
        ShowMenu:= false;
        EnableMenu:= false;

        //Hide toolbar
        ToolbarMain.Visible:= false;

        //Hide navigation panel
        {$ifdef PRO}
        ShowNav:= false;
        {$endif}

        //Hide min/max buttons
        BorderIcons:= [biSystemMenu];

        //Set "Always on top" style
        FormStyle:= fsStayOnTop;
        
        //Disable message boxes
        ATViewerMessagesEnabled:= false;

        Continue;
        end;

      // /QB: Hide window border+caption.
      if SU = '/QB' then
        begin
        //BorderStyle:= bsNone;
        SetFormStyle(Self, false);
        Continue;
        end;

      // /QT: Hide taskbar icon.
      if SU = '/QT' then
        begin
        FNoTaskbarIcon:= true;
        Continue;
        end;

      // /P: Specify window position.
      if Pos('/P=', SU) = 1 then
        begin
        Delete(S, 1, Length('/P='));
        if (S <> '') then Left:= StrToIntDef(SGetListValue(S), Left);
        if (S <> '') then Top:= StrToIntDef(SGetListValue(S), Top);
        if (S <> '') then Width:= StrToIntDef(SGetListValue(S), Width);
        if (S <> '') then Height:= StrToIntDef(SGetListValue(S), Height);
        Continue;
        end;

      // /Pos: Specify file position.
      if Pos('/POS=', SU) = 1 then
        begin
        Delete(S, 1, Length('/POS='));

        if (S <> '') then
          begin
          FStartupPosDo:= true;
          FStartupPosLine:= UpperCase(S[Length(S)]) = 'N';
          FStartupPosPercent:= UpperCase(S[Length(S)]) = 'P';
          if not (Char(S[Length(S)]) in ['0'..'9']) then
            Delete(S, Length(S), 1);
          FStartupPos:= StrToIntDef(S, 0);
          end;

        Continue;
        end;

      // /Mode: Specify view mode.
      if Pos('/MODE=', SU) = 1 then
        begin
        Delete(SU, 1, Length('/MODE='));

        Viewer.ModeDetect:= false;
        Viewer.Mode:= IntegerToMode(StrToIntDef(SU, 1), vmodeText);

        Continue;
        end;
      end;

    //Handle @Filelist parameter
    if Pos('@', S) = 1 then
      begin
      Delete(S, 1, 1);
      if FFileList.ReadFileList(S) then
        S:= FFileList.GetFirst
      else
        Exit;
      end;

    //Filename (maybe got from @Filelist) returned as result
    Result:= S;
    end;
end;

//-------------------------------------------------
procedure TFormViewUV.WMCopyData(var Msg: TWMCopyData);
var
  S: WideString;
  IsDir: boolean;
begin
  BOOL(Msg.Result):= (Msg.From <> 0) and Self.Visible;
  if BOOL(Msg.Result) then
    begin
    Application.Restore;
    with Msg.CopyDataStruct^ do
      if cbData > 0 then
        begin
        case dwData of
          100: //"Open ANSI filename"
            S:= string(PChar(lpData));
          101: //"Open Unicode filename"
            S:= WideString(PWChar(lpData));
          else
            S:= '';
        end;

        //Clear old filelist
        FFileList.Locked:= false;

        //Create new filelist, if needed
        if Pos('@', S) = 1 then
          begin
          Delete(S, 1, 1);
          if FFileList.ReadFileList(S) then
            S:= FFileList.GetFirst
          else
            S:= '';
          end;

        //Both files and folders allowed (IsDir specified)
        if IsFileExist(S, IsDir) then
          LoadFile(S, true)
        else
          CloseFile;
        end;
    end;
end;
