unit UFormPluginsOptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TFormPluginsOptions = class(TForm)
    btnCancel: TButton;
    btnOK: TButton;
    boxPlugins: TGroupBox;
    List: TListView;
    btnAdd: TButton;
    btnRemove: TButton;
    btnConfig: TButton;
    btnUp: TButton;
    btnDown: TButton;
    boxOptions: TGroupBox;
    chkPriority: TCheckBox;
    chkTCVar: TCheckBox;
    chkHideKeys: TCheckBox;
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnConfigClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
  private
    { Private declarations }
    procedure MsgInstall(sAdded, sDups: string);
    function PluginPresent(const fn: string): boolean;
    procedure AddPluginsFromTCIni(const fExeFilename, fIniFilename: string);
    procedure AddPluginsFromFolder(const fn: string);
    procedure AddPluginFile(const fn: string);
    procedure AddPluginZip(const fn: string);
  public
    { Public declarations }
  end;

implementation

uses
  ATxSProc, ATxFProc, WLXProc,
  ATxMsg, ATxMsgProc, ATViewerMsg,
  ATxUtils, ATxTotalCmd, ATxVersionInfo,
  UFormPluginsAdd, UFormPluginsEdit;

{$R *.DFM}

procedure ListSwapItems(List: TListView; n1, n2: integer);
var
  s: string;
  en: boolean;
begin
  with List do
    begin
    Items.BeginUpdate;

    s:= Items[n1].Caption;
    Items[n1].Caption:= Items[n2].Caption;
    Items[n2].Caption:= s;

    s:= Items[n1].SubItems[0];
    Items[n1].SubItems[0]:= Items[n2].SubItems[0];
    Items[n2].SubItems[0]:= s;

    s:= Items[n1].SubItems[1];
    Items[n1].SubItems[1]:= Items[n2].SubItems[1];
    Items[n2].SubItems[1]:= s;

    en:= Items[n1].Checked;
    Items[n1].Checked:= Items[n2].Checked;
    Items[n2].Checked:= en;

    Items.EndUpdate;
    end;
end;

procedure ListSelect(List: TListView; n: integer);
begin
  with List do
    begin
    if n>Items.Count-1 then Dec(n);
    if n>=0 then
      begin
      ItemFocused:= Items[n];
      Selected:= ItemFocused;
      Selected.MakeVisible(false);
      end;
    end;
end;

procedure TFormPluginsOptions.btnAddClick(Sender: TObject);
var
  fn1, fn2: AnsiString;
begin
  with TFormPluginsAdd.Create(Self) do
    try
      chkSrcFile.Checked:= true;
      if ShowModal=mrOk then
        begin
        fn1:= edPath1.Text;
        fn2:= edPath2.Text;
        if chkSrcFolder.Checked then AddPluginsFromFolder(fn1) else
         if chkSrcTC.Checked then AddPluginsFromTCIni(fn2, fn1) else
          if chkSrcZip.Checked then AddPluginZip(fn1) else
           if chkSrcFile.Checked then AddPluginFile(fn1);
        end;
    finally
      Release;
    end;
end;

procedure TFormPluginsOptions.btnRemoveClick(Sender: TObject);
var
  n: integer;
begin
  with List do
    if Assigned(Selected) then
      begin
      n:= Selected.Index;
      List.Items.Delete(n);
      ListSelect(List, n);
      end;
end;

procedure TFormPluginsOptions.btnConfigClick(Sender: TObject);
begin
  with List do
    if Assigned(Selected) then
      with Items[Selected.Index] do
        with TFormPluginsEdit.Create(Self) do
          try
            edFilename.Text:= SubItems[1];
            edDetect.Text:= SubItems[0];
            if ShowModal=mrOk then
              SubItems[0]:= edDetect.Text;
          finally
            Release;
          end;
end;

procedure TFormPluginsOptions.btnUpClick(Sender: TObject);
var
  n: integer;
begin
  with List do
    if Assigned(Selected) then
      begin
      n:= Selected.Index;
      if n>0 then
        begin
        ListSwapItems(List, n, n-1);
        ListSelect(List, n-1);
        end;
      end;
end;

procedure TFormPluginsOptions.btnDownClick(Sender: TObject);
var
  n: integer;
begin
  with List do
    if Assigned(Selected) then
      begin
      n:= Selected.Index;
      if n<Items.Count-1 then
        begin
        ListSwapItems(List, n, n+1);
        ListSelect(List, n+1);
        end;
      end;
end;

procedure TFormPluginsOptions.FormShow(Sender: TObject);
begin
  {$I Lang.FormPluginsOptions.inc}

  ListSelect(List, 0);
  ListSelectItem(Self, nil, false);
end;

function TFormPluginsOptions.PluginPresent(const fn: TWlxFilename): boolean;
var
  i: integer;
begin
  Result:= false;
  with List do
  for i:= 0 to Items.Count-1 do
    begin
    if StrIComp(PChar(fn), PChar(Items[i].SubItems[1]))=0 then
      begin Result:= true; Break end;
    end;
end;

procedure TFormPluginsOptions.MsgInstall(sAdded, sDups: string);
begin
  if sAdded='' then sAdded:= MsgViewerPluginsMsgNone;
  if sDups='' then sDups:= MsgViewerPluginsMsgNone;
  MsgInfo(Format(MsgViewerPluginsMsgInstalled, [sAdded, sDups]), Handle);
end;

procedure TFormPluginsOptions.AddPluginsFromTCIni(const fExeFilename, fIniFilename: string);
const
  Section = 'ListerPlugins';
var
  i: integer;
  fn: TWlxFilename;
  detect, desc: string;
  sAdded, sDups: string;
begin
  if (fIniFilename='') or (not IsFileExist(fIniFilename)) then
    begin MsgError(MsgViewerPluginsErrInvalidFile, Handle); Exit end;

  if (fExeFilename='') or (Pos('Total Commander', FGetVersionInfo(fExeFilename, vsFileDescription))=0) then
    begin MsgError(MsgViewerPluginsErrInvalidTCExe, Handle); Exit end;

  SetEnvironmentVariable('COMMANDER_PATH', PChar(ExtractFileDir(fExeFilename)));
  sAdded:= '';
  sDups:= '';

  with List do
    begin
    //Items.BeginUpdate;

    for i:= 0 to WlxPluginsMaxCount-1 do
      begin
      SetTcIniFilename(fIniFilename);
      fn:= GetTcIniKey(Section, IntToStr(i));
      fn:= SExpandVars(fn);
      if fn='' then Break;
      detect:= GetTcIniKey(Section, IntToStr(i)+'_detect');
      if detect='' then
        detect:= WlxGetDetectString(fn);
      desc:= SPluginName(fn);

      if PluginPresent(fn) then
        begin
        sDups:= sDups+desc+#13;
        end
      else
        begin
        sAdded:= sAdded+desc+#13;
        with Items.Add do
          begin
          Checked:= true;
          Caption:= desc;
          SubItems.Add(detect);
          SubItems.Add(fn);
          end;
        end;
        end;

    //Items.EndUpdate;

    MsgInstall(sAdded, sDups);
    end;
end;

procedure TFormPluginsOptions.AddPluginFile(const fn: TWlxFilename);
var
  detect, desc: string;
  sAdded, sDups: string;
begin
  if (fn='') or (not IsFileExist(fn)) then
    begin MsgError(MsgViewerPluginsErrInvalidFile, Handle); Exit end;

  sAdded:= '';
  sDups:= '';

  detect:= WlxGetDetectString(fn);
  desc:= SPluginName(fn);

  if PluginPresent(fn) then
    begin
    sDups:= sDups+desc+#13;
    end
  else
    begin
    sAdded:= sAdded+desc+#13;
    with List.Items.Add do
      begin
      Checked:= true;
      Caption:= desc;
      SubItems.Add(detect);
      SubItems.Add(fn);
      end;
    end;

  MsgInstall(sAdded, sDups);
end;


procedure TFormPluginsOptions.AddPluginZip(const fn: TWlxFilename);
begin
  //
end;

procedure TFormPluginsOptions.AddPluginsFromFolder(const fn: TWlxFilename);
begin
  //
end;

procedure TFormPluginsOptions.ListSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
var
  Sel: boolean;
begin
  Sel:= Assigned(List.Selected);
  btnRemove.Enabled:= Sel;
  btnConfig.Enabled:= Sel;
  btnUp.Enabled:= Sel and (List.Selected.Index>0);
  btnDown.Enabled:= Sel and (List.Selected.Index<List.Items.Count-1);
end;

end.
