unit ATViewerMsg;

interface

uses
  Windows;

function MsgBox(const Msg, Title: WideString; Flags: Integer;
  hWnd: THandle = INVALID_HANDLE_VALUE): Integer;
procedure MsgInfo(const Msg: WideString; hWnd: THandle = INVALID_HANDLE_VALUE);
procedure MsgError(const Msg: WideString; hWnd: THandle = INVALID_HANDLE_VALUE);
procedure MsgWarning(const Msg: WideString; hWnd: THandle = INVALID_HANDLE_VALUE);

var
  ATViewerMessagesEnabled: Boolean = True;

var
  MsgViewerCaption: string = 'Viewer';
  MsgViewerErrCannotFindFile: string = 'File not found: "%s"';
  MsgViewerErrCannotFindFolder: string = 'Folder not found: "%s"';
  MsgViewerErrCannotOpenFile: string = 'Cannot open file: "%s"';
  MsgViewerErrCannotLoadFile: string = 'Cannot load file: "%s"';
  MsgViewerErrCannotReadFile: string = 'Cannot read file: "%s"';
  MsgViewerErrCannotReadStream: string = 'Cannot read stream';
  MsgViewerErrCannotReadPos: string = 'Read error at offset %s';
  MsgViewerErrImage: string = 'Unknown image format';
  MsgViewerErrMedia: string = 'Unknown multimedia format';
  MsgViewerErrInitControl: string = 'Cannot initialize %s';
  MsgViewerErrCannotCopyData: string = 'Cannot copy data to Clipboard';
  MsgViewerWlxException: string = 'Exception in plugin "%s" in function "%s"';
  MsgViewerWlxParentNotSpecified: string = 'Cannot load plugins: parent form not specified';
  MsgViewerAniTitle: string = 'Title: ';
  MsgViewerAniCreator: string = 'Creator: ';

implementation

uses
  SysUtils, Forms;

function MsgBox(
  const Msg, Title: WideString;
  Flags: Integer;
  hWnd: THandle = INVALID_HANDLE_VALUE): Integer;
begin
  if not ATViewerMessagesEnabled then
    begin Result := IDCANCEL; Exit end;

  if hWnd = INVALID_HANDLE_VALUE then
    if Assigned(Application) then
    begin
      if Assigned(Application.MainForm) then
        hWnd := Application.MainForm.Handle
      else
        hWnd := Application.Handle;
    end;

  if Win32Platform = VER_PLATFORM_WIN32_NT then
    Result:= MessageBoxW(hWnd, PWideChar(Msg), PWideChar(Title), Flags or MB_SETFOREGROUND)
  else
    Result:= MessageBoxA(hWnd, PAnsiChar(AnsiString(Msg)), PAnsiChar(AnsiString(Title)), Flags or MB_SETFOREGROUND);
end;

procedure MsgInfo(
  const Msg: WideString;
  hWnd: THandle = INVALID_HANDLE_VALUE);
begin
  MsgBox(Msg, MsgViewerCaption, MB_OK or MB_ICONINFORMATION, hWnd);
end;

procedure MsgError(
  const Msg: WideString;
  hWnd: THandle = INVALID_HANDLE_VALUE);
begin
  MsgBox(Msg, MsgViewerCaption, MB_OK or MB_ICONERROR, hWnd);
end;

procedure MsgWarning(
  const Msg: WideString;
  hWnd: THandle = INVALID_HANDLE_VALUE);
begin
  MsgBox(Msg, MsgViewerCaption, MB_OK or MB_ICONEXCLAMATION, hWnd);
end;

end.
